/*
 * Decompiled with CFR 0.152.
 */
package com.utility;

import com.dto.LoginDto;
import com.utility.CodeCheckerResult;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import com.utility.TncLog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class CodeChecker {
    private final LoginDto login;
    private final DbConnection dbConnection;
    private final String tableName;
    private final TncLog log = new TncLog();

    public synchronized CodeCheckerResult findUnavailableCodes(String codesStr, String methodName, String crudNumbersStr) {
        if (methodName.contains("deleteTable")) {
            return this.getDefaultCodeCheckerResult(codesStr, crudNumbersStr);
        }
        String tableCodeField = this.getTableCodeField(this.tableName);
        if (tableCodeField == null) {
            return this.getDefaultCodeCheckerResult(codesStr, crudNumbersStr);
        }
        ArrayList<String> codesList = new ArrayList<String>(Arrays.asList(codesStr.split(",")));
        ArrayList<String> crudCodeList = new ArrayList<String>(Arrays.asList(crudNumbersStr.split(",")));
        String codes = ConvertStr.bindStringsWrapByCharacter(codesList, (String)"('", (String)"')");
        List unavailableCodes = this.dbConnection.getJdbcTemplate(this.login).queryForList(" SELECT * FROM (VALUES " + codes + ") AS ACODELIST(THE_CODE) WHERE ACODELIST.THE_CODE NOT IN (SELECT " + tableCodeField + " FROM " + this.tableName + ")");
        if (ConvertStr.isNullOrEmpty((Collection)unavailableCodes)) {
            return this.getDefaultCodeCheckerResult(codesStr, crudNumbersStr);
        }
        for (Map theCode : unavailableCodes) {
            int index = codesList.indexOf(String.valueOf(theCode.get("THE_CODE")));
            if (index == -1) continue;
            codesList.remove(index);
            crudCodeList.remove(index);
        }
        String availableACodes = ConvertStr.getCommaSeparatedString(codesList);
        String availableMessage = ConvertStr.getCommaSeparatedString(crudCodeList);
        this.log.info("method: " + methodName + " dbName: " + this.login.getDatabaseName() + " *** unavailable codes: " + unavailableCodes + "\n *** inserted codes: " + availableACodes);
        ArrayList mutableUnavailableCodes = new ArrayList(unavailableCodes);
        unavailableCodes.add(Collections.singletonMap("dbName", this.login.getDatabaseName()));
        return new CodeCheckerResult(availableACodes, availableMessage, mutableUnavailableCodes);
    }

    @NotNull
    private CodeCheckerResult getDefaultCodeCheckerResult(String codesStr, String crudNumbersStr) {
        return new CodeCheckerResult(codesStr, crudNumbersStr, new ArrayList());
    }

    private String getTableCodeField(String tableName) {
        String field = null;
        if (tableName.equalsIgnoreCase("Article")) {
            field = "A_CODE";
        } else if (tableName.equalsIgnoreCase("M_Group")) {
            field = "M_GroupCode";
        } else if (tableName.equalsIgnoreCase("S_Group")) {
            field = "M_GroupCode + S_GroupCode";
        }
        return field;
    }

    public CodeChecker(LoginDto login, DbConnection dbConnection, String tableName) {
        this.login = login;
        this.dbConnection = dbConnection;
        this.tableName = tableName;
    }
}

